/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.api.serialization;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import java.util.Map;
import java.util.Optional;
import net.darkhax.bookshelf.Constants;
import net.darkhax.bookshelf.api.serialization.ISerializer;
import net.darkhax.bookshelf.api.serialization.NBTParseException;
import net.darkhax.bookshelf.api.serialization.Serializers;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2680;
import net.minecraft.class_2746;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3518;

public class SerializerBlockState
implements ISerializer<class_2680> {
    public static final ISerializer<class_2680> SERIALIZER = new SerializerBlockState();

    private SerializerBlockState() {
    }

    @Override
    public class_2680 fromJSON(JsonElement json) {
        JsonPrimitive primitive;
        if (json.isJsonObject()) {
            JsonObject obj = json.getAsJsonObject();
            class_2248 block = Serializers.BLOCK.fromJSON(obj, "block");
            class_2680 state = block.method_9564();
            if (obj.has("properties")) {
                JsonElement properties = obj.get("properties");
                for (Map.Entry property : properties.getAsJsonObject().entrySet()) {
                    state = this.readProperty(state, (String)property.getKey(), (JsonElement)property.getValue());
                }
            }
            return state;
        }
        if (json instanceof JsonPrimitive && (primitive = (JsonPrimitive)json).isString()) {
            class_2248 block = Serializers.BLOCK.fromJSON(json);
            if (block != null) {
                return block.method_9564();
            }
            throw new JsonParseException("Block ID is missing or invalid. '" + json.getAsString() + "'");
        }
        throw new JsonParseException("Expected properties to be an object. Recieved " + class_3518.method_15266((JsonElement)json));
    }

    @Override
    public JsonElement toJSON(class_2680 toWrite) {
        JsonObject json = new JsonObject();
        json.add("block", Serializers.BLOCK.toJSON(toWrite.method_26204()));
        JsonObject properties = new JsonObject();
        for (class_2769 prop : toWrite.method_28501()) {
            if (prop instanceof class_2758) {
                properties.addProperty(prop.method_11899(), (Number)((Object)toWrite.method_11654((class_2769)((class_2758)prop))));
                continue;
            }
            if (prop instanceof class_2746) {
                properties.addProperty(prop.method_11899(), (Boolean)toWrite.method_11654((class_2769)((class_2746)prop)));
                continue;
            }
            properties.addProperty(prop.method_11899(), prop.method_11901(toWrite.method_11654(prop)));
        }
        json.add("properties", (JsonElement)properties);
        return json;
    }

    @Override
    public class_2680 fromByteBuf(class_2540 buffer) {
        return class_2248.method_9531((int)buffer.readInt());
    }

    @Override
    public void toByteBuf(class_2540 buffer, class_2680 toWrite) {
        buffer.writeInt(class_2248.method_9507((class_2680)toWrite));
    }

    private class_2680 readProperty(class_2680 state, String propName, JsonElement propValue) {
        class_2769 blockProperty = state.method_26204().method_9595().method_11663(propName);
        if (blockProperty != null) {
            if (propValue.isJsonPrimitive()) {
                String valueString = propValue.getAsString();
                Optional parsedValue = blockProperty.method_11900(valueString);
                if (parsedValue.isPresent()) {
                    try {
                        return (class_2680)state.method_11657(blockProperty, (Comparable)parsedValue.get());
                    }
                    catch (Exception e) {
                        Constants.LOG.error("Failed to update state for block {}. The mod that adds this block may have an issue.", (Object)class_2378.field_11146.method_10206((Object)state.method_26204()));
                        Constants.LOG.trace("Failed to read blockstate from JSON property.", (Throwable)e);
                        throw e;
                    }
                }
                throw new JsonSyntaxException("The property " + propName + " with value " + valueString + " coul not be parsed!");
            }
            throw new JsonSyntaxException("Expected property value for " + propName + " to be primitive string. Got " + class_3518.method_15266((JsonElement)propValue));
        }
        throw new JsonSyntaxException("The property " + propName + " is not valid for block " + class_2378.field_11146.method_10206((Object)state.method_26204()));
    }

    @Override
    public class_2520 toNBT(class_2680 toWrite) {
        return class_2512.method_10686((class_2680)toWrite);
    }

    @Override
    public class_2680 fromNBT(class_2520 nbt) {
        if (nbt instanceof class_2487) {
            class_2487 compound = (class_2487)nbt;
            return class_2512.method_10681((class_2487)compound);
        }
        throw new NBTParseException("Expected NBT to be a compound tag. Class was " + nbt.getClass() + " with ID " + nbt.method_10711() + " instead.");
    }
}

